package com.bxm.localnews.sync.task;

import java.util.Date;

import com.bxm.localnews.service.NewsStatisticService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.quartz.DisallowConcurrentExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
/**
 * 消费新闻静态数据
 */
@DisallowConcurrentExecution
public class ConsumeNewsStatisticJob extends AbstractCustomJob {

    Logger logger = LoggerFactory.getLogger(ConsumeNewsStatisticJob.class);

    @Autowired
    private NewsStatisticService newsStatisticService;

    public ConsumeNewsStatisticJob() {
        super("ConsumeNewsStatisticJob", "0 0/5 * * * ?", "消费新闻静态数据!");
    }

    @Override
    public Message service() {
        logger.info("开始消费新闻静态数据！当前时间：{}", new Date());
        newsStatisticService.sync();
        return Message.build();
    }
}
