package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.NewsPoolSyncService;
import com.bxm.localnews.service.NewsSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;

public class NewsPoolSyncThread implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(NewsPoolSyncThread.class);

    private NewsPoolSyncService newsPoolSyncService;

    private CountDownLatch countDownLatch;

    private Integer offset;

    public NewsPoolSyncThread build(Integer offset, CountDownLatch countDownLatch) {
        this.newsPoolSyncService = SpringContextHolder.getApplicationContext().getBean(NewsPoolSyncService.class);
        this.countDownLatch = countDownLatch;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("news_pool thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.newsPoolSyncService.sync(this.offset);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.countDownLatch.countDown();
        }
        logger.debug("news_pool thread:" + Thread.currentThread().getId() + "end work");
    }

}
