package com.bxm.localnews.sync.task;


import com.bxm.localnews.service.CouponService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;


@Component
public class SyncCouponJob extends AbstractCustomJob {

    @Resource
    private CouponService couponService;

    public SyncCouponJob() {
        super("syncCoupon", "0 0/10 * * * ?", "优惠券同步任务");
    }

    @Override
    public Message service() {
        logger.info("开始同步优惠券数据！当前时间：{}",new Date());
        this.couponService.sync();
        return Message.build();
    }


}
