package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.ForumPostService;
import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 由于用户服务出现bug，根据id获取用户信息时没有用户头像或者昵称，导致库里这一部分数据有残缺
 * 在这里进行数据的补录，主要分【评论、帖子点赞、帖子】三部分
 */
@Component
@DisallowConcurrentExecution
public class SyncUserRedundancyInfoJob extends AbstractCustomJob {


    @Autowired
    private ForumPostService forumPostService;

    @Autowired
    private NewsInfoSyncService newsInfoSyncService;

    public SyncUserRedundancyInfoJob() {
        super("SyncUserRedundancyInfoJob", "0 0/50 * * * ?", "用户冗余数据同步任务");
    }

    @Override
    public Message service() {
        logger.info("开始修正用户冗余数据！当前时间：{}",new Date());

        /**
         * 帖子表或者帖子点赞表中有出现空用户的
         */
        forumPostService.scanningForumPost();

        /**
         * 评论表中有出现空用户的
         */
        newsInfoSyncService.syncNewsReply();
        return Message.build();
    }
}
