/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.NewsPoolSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsPoolSyncThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NewsPoolSyncThread.class);
    private NewsPoolSyncService newsPoolSyncService;
    private CountDownLatch countDownLatch;
    private Integer offset;

    public NewsPoolSyncThread build(Integer offset, CountDownLatch countDownLatch) {
        this.newsPoolSyncService = (NewsPoolSyncService)SpringContextHolder.getApplicationContext().getBean(NewsPoolSyncService.class);
        this.countDownLatch = countDownLatch;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("news_pool thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.newsPoolSyncService.sync(this.offset);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
        logger.debug("news_pool thread:" + Thread.currentThread().getId() + "end work");
    }
}

