package com.bxm.localnews.sync.task;


import com.bxm.localnews.service.NewsCleanService;
import com.bxm.localnews.sync.thread.NewsSyncThread;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.CountDownLatch;


@Component
@DisallowConcurrentExecution
public class CleanNewsJob extends AbstractCustomJob {

    @Resource
    private NewsCleanService newsCleanService;

    public CleanNewsJob() {
        super("CleanNewsJob", "0 0 3 * * ?", "新闻推荐池定期清理任务");
    }

    @Override
    public Message service() {
        logger.info("开始定时清理新闻!");
        newsCleanService.clean();
        return Message.build();
    }

}
