package com.bxm.localnews.sync.task;

import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.third.dao.UserMapper;
import com.bxm.localnews.sync.thread.NewsCommentSyncThread;
import com.bxm.localnews.sync.thread.UserStatisticCalThread;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

@Component
@DisallowConcurrentExecution
public class NewsCommentSyncJob extends AbstractCustomJob {

    @Resource
    private NewsMapper newsMapper;

    private static CountDownLatch countDownLatch = null;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    /**
     * 分表总数
     */
    private int tableTotal = 10;

    public NewsCommentSyncJob() {
        super("NewsCommentSyncJob", "0 0 5 * * ?", "新闻评论同步");
    }

    @Override
    public Message service() {
        logger.info("开始同步新闻评论数!");
        if (countDownLatch == null || countDownLatch.getCount() == 0) {
            List<Long> idList = newsMapper.getNewsIdByIssueTime();
            countDownLatch = new CountDownLatch(this.tableTotal);
            for (int i = 0; i < this.tableTotal; i++) {
                int finalI = i;
                List<Long> filterIdList;
                filterIdList = idList.stream().filter(x -> (x % 10) == finalI).collect(Collectors.toList());

                this.taskExecutor.execute(new NewsCommentSyncThread().build(i,filterIdList, countDownLatch));
            }
        } else {
            this.logger.debug("上一次同步工作还没做完" + countDownLatch.getCount());
        }
        return Message.build();

    }

}
