package com.bxm.localnews.sync.task;

import javax.annotation.Resource;

import com.bxm.localnews.config.SyncProperties;
import com.bxm.localnews.service.IDataVideoServie;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.springframework.stereotype.Component;

/**
 * 同步idata的视频信息
 *
 * @author zhaoyadong
 */
@Component
public class SyncIDataVideoJob extends AbstractCustomJob {

    @Resource
    private SyncProperties syncProperties;

    @Resource
    private IDataVideoServie iDataVideoServie;

    public SyncIDataVideoJob() {
        super("syncIDataVideo", "0 5 0/4 * * ? ", "idata视频同步任务");
    }

    @Override
    public Message service() {
        if (syncProperties.getSwtichType() == 1) {

            this.iDataVideoServie.sync();
        }
        return Message.build();
    }

}
