package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.OldLocalNewsSyncService;
import com.bxm.localnews.service.OldNewsSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
/**
 * 同步新闻的内容
 */
@DisallowConcurrentExecution
public class SyncOldLocalNewJob extends AbstractCustomJob {

    Logger logger = LoggerFactory.getLogger(SyncOldLocalNewJob.class);

    @Autowired
    private OldLocalNewsSyncService syncNewContentService;

    public SyncOldLocalNewJob() {
        super("SyncOldLocalJob", "0 0/5 * * * ?", "同步新闻内容!");
    }

    @Override
    public Message service() {
        logger.info("开始同步本地数据!");
//        syncNewContentService.sync();
        return Message.build();
    }
}
