package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.OldNewsSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
/**
 * 同步新闻的内容
 */
@DisallowConcurrentExecution
public class SyncOldNewJob extends AbstractCustomJob {

    Logger logger = LoggerFactory.getLogger(SyncOldNewJob.class);

    @Autowired
    private OldNewsSyncService syncNewContentService;

    public SyncOldNewJob() {
        super("SyncNewContentJob", "0 0/20 * * * ?", "同步新闻内容!");
    }

    @Override
    public Message service() {
        logger.info("开始同步数据!");
//        syncNewContentService.sync();
        return Message.build();
    }
}
