package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.WechatNewsSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 微信公众号同步任务配置
 * @author zhaoyadong 2018/11/20 15:03
 */
@Component
public class SyncWechatNewsJob extends AbstractCustomJob {

    @Resource
    private WechatNewsSyncService wechatNewsSyncService;

    public SyncWechatNewsJob() {
        super("syncWechatNews", "0 0/15 * * * ?", "微信公众号新闻同步任务");
    }

    @Override
    public Message service() {
        this.wechatNewsSyncService.sync();
        return Message.build();
    }
}
