package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.CountDownLatch;

public class NewsCommentSyncThread implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(UserStatisticCalThread.class);

    private NewsInfoSyncService newsInfoSyncService;

    private CountDownLatch countDownLatch;

    private Integer offset;

    private List<Long> idList;

    public NewsCommentSyncThread build(Integer offset, List<Long> idList, CountDownLatch countDownLatch) {
        this.newsInfoSyncService = SpringContextHolder.getApplicationContext().getBean(NewsInfoSyncService.class);
        this.countDownLatch = countDownLatch;
        this.idList = idList;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("news comment thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.newsInfoSyncService.syncNewsComment(idList,this.offset);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.countDownLatch.countDown();
        }
        logger.debug("news comment thread:" + Thread.currentThread().getId() + "end work");
    }

}
