/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.sync.task;

import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.thread.NewsCommentSyncThread;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class NewsCommentSyncJob
extends AbstractCustomJob {
    @Resource
    private NewsMapper newsMapper;
    private static CountDownLatch countDownLatch = null;
    @Resource
    private AsyncTaskExecutor taskExecutor;
    private int tableTotal = 10;

    public NewsCommentSyncJob() {
        super("NewsCommentSyncJob", "0 0 5 * * ?", "\u65b0\u95fb\u8bc4\u8bba\u540c\u6b65");
    }

    public Message service() {
        this.logger.info("\u5f00\u59cb\u540c\u6b65\u65b0\u95fb\u8bc4\u8bba\u6570!");
        if (countDownLatch == null || countDownLatch.getCount() == 0L) {
            List idList = this.newsMapper.getNewsIdByIssueTime();
            countDownLatch = new CountDownLatch(this.tableTotal);
            for (int i = 0; i < this.tableTotal; ++i) {
                int finalI = i;
                List<Long> filterIdList = idList.stream().filter(x -> x % 10L == (long)finalI).collect(Collectors.toList());
                this.taskExecutor.execute((Runnable)new NewsCommentSyncThread().build(i, filterIdList, countDownLatch));
            }
        } else {
            this.logger.debug("\u4e0a\u4e00\u6b21\u540c\u6b65\u5de5\u4f5c\u8fd8\u6ca1\u505a\u5b8c" + countDownLatch.getCount());
        }
        return Message.build();
    }
}

