/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.sync.thread;

import com.bxm.localnews.service.UserStatisticService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStatisticCalThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UserStatisticCalThread.class);
    private UserStatisticService userStatisticService;
    private CountDownLatch countDownLatch;
    private Integer offset;
    private List<Long> idList;

    public UserStatisticCalThread build(Integer offset, List<Long> idList, CountDownLatch countDownLatch) {
        this.userStatisticService = (UserStatisticService)SpringContextHolder.getApplicationContext().getBean(UserStatisticService.class);
        this.countDownLatch = countDownLatch;
        this.idList = idList;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("user statistic thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.userStatisticService.sync(this.idList, this.offset);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
        logger.debug("user statistic thread:" + Thread.currentThread().getId() + "end work");
    }
}

