/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.OperateUserPointDTO;
import com.bxm.localnews.thirdparty.dto.PointMallDTO;
import com.bxm.localnews.thirdparty.dto.PointStoreBaseDTO;
import com.bxm.localnews.thirdparty.dto.UserPointDTO;
import com.bxm.localnews.thirdparty.service.PointMallService;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-08 \u79ef\u5206\u5546\u57ce\u76f8\u5173\u63a5\u53e3"}, description="\u79ef\u5206\u5546\u57ce\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/public/points"})
public class PointMallController {
    private PointMallService pointMallService;

    @Autowired
    public PointMallController(PointMallService pointMallService) {
        this.pointMallService = pointMallService;
    }

    @ApiOperation(value="3-08-1 \u6839\u636e\u680f\u4f4d\u83b7\u53d6\u5546\u54c1\u4fe1\u606f", notes="type: 1:\u79ef\u5206\u5546\u57ce\uff1b2\uff1a\u5546\u54c1\uff1b3\uff1a\u5927\u8f6c\u76d8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false), @ApiImplicitParam(name="type", value="\u5546\u54c1\u680f\u4f4d", allowableValues="1, 2, 3", paramType="path", dataType="String", required=true)})
    @GetMapping(value={"/{type}"})
    public Json<List<PointMallDTO>> pointsMallByType(@RequestParam(value="userId", required=false) Long userId, @PathVariable(value="type") String type) {
        return ResultUtil.genSuccessResult((Object)this.pointMallService.getPointsMallByType(userId, type));
    }

    @ApiOperation(value="3-08-2 \u6839\u636eid\u83b7\u53d6\u8df3\u8f6c\u94fe\u63a5", notes="id\u4e3a0\u65f6\uff0c\u751f\u6210\u79ef\u5206\u5546\u57ce\u9996\u9875\u94fe\u63a5\uff0c\u4e3a1\u65f6\u751f\u6210\u5927\u8f6c\u76d8\u8df3\u8f6c\u94fe\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u5546\u54c1id", required=true)})
    @GetMapping(value={"/{id}/url"})
    public Json<String> pointsMallById(@PathVariable(value="id") Long id, @RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.pointMallService.getPointMallById(id, userId));
    }

    @ApiOperation(value="3-08-3 \u7528\u6237\u91d1\u5e01\u4fe1\u606f", notes="", hidden=true)
    @RequestMapping(value={"/get/balance"}, method={RequestMethod.GET})
    public UserPointDTO userBalance(StoreNeceParam storeNeceParam) {
        return this.pointMallService.selectJbBalanceByUserId(storeNeceParam);
    }

    @ApiOperation(value="3-08-4 \u6263\u9664\u7528\u6237\u91d1\u5e01", notes="", hidden=true)
    @RequestMapping(value={"/deduct/balance"}, method={RequestMethod.POST})
    public OperateUserPointDTO deductBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.deductUserBalance(deductPointParam);
    }

    @ApiOperation(value="3-08-5 \u786e\u8ba4\u6263\u9664\u7528\u6237\u91d1\u5e01", notes="", hidden=true)
    @RequestMapping(value={"/confirm/deduct/balance"}, method={RequestMethod.POST})
    public PointStoreBaseDTO confirmDeductBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.deductConfirmUserBalance(deductPointParam);
    }

    @ApiOperation(value="3-08-6 \u6dfb\u52a0\u7528\u6237\u91d1\u5e01", notes="", hidden=true)
    @RequestMapping(value={"/balance"}, method={RequestMethod.POST})
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        return this.pointMallService.addUserBalance(deductPointParam);
    }
}

