package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.service.AllotDomainService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/26 15:29
 * @desc 随机分发域名前缀
 */
@Api(tags = "3-16 获取域名相关信息", description = "域名配置相关操作")
@RestController
@RequestMapping("api/public/domain")
public class AllotDomainController {

    @Autowired
    private AllotDomainService allotDomainService;

    @ApiOperation(value = "3-16-1 随机获取域名前缀信息", notes = "随机获取域名信息")
    @GetMapping("/random")
    public Json<String> getRandomDomain() {
        return ResultUtil.genSuccessResult(allotDomainService.getRandomDomain());
    }
}
