package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipFile;

@Api(tags = "3-02 资源下载", description = "包括提供andriod的自定义包下载流")
@Controller

@RequestMapping("api/download")
public class AndriodDownloadController extends BaseController {

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AndriodDownloadController(BizConfigProperties bizConfigProperties) {
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation(value = "3-02-1 安卓安装包下载", notes = "根据邀请码返回带有邀请码信息的安卓安装包，安装包中的额外内容为ic={邀请码}")
    @ApiImplicitParam(name = "inviteCode", value = "邀请码(userId)", paramType = "path", dataType = "String", required = true)
    @RequestMapping(value = "/andriod/{inviteCode}", method = RequestMethod.GET)
    public void andriod(@PathVariable String inviteCode, HttpServletResponse response) throws IOException {
        this.processDownload("本地万事通.apk", response);
        this.writeApk(this.getApkFile(), inviteCode, response.getOutputStream());
    }

    /**
     * 写入文件
     * @param file
     * @param comment
     * @param outputStream
     * @throws IOException
     */
    private void writeApk(File file, String comment, OutputStream outputStream) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            String zipComment = zipFile.getComment();
            if (zipComment != null) {
                return;
            }

            byte[] byteComment = comment.getBytes();
            byteComment = ArrayUtils.addAll(byteComment, BitOperatorUtil.short2Byte((short) byteComment.length));

            IOUtils.copyLarge(new FileInputStream(file), outputStream, 0, file.length() - 2);
            IOUtils.write(BitOperatorUtil.short2Byte((short) byteComment.length), outputStream);
            IOUtils.write(byteComment, outputStream);
            outputStream.flush();
        } finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /**
     * 获取文件
     * @return
     */
    private File getApkFile() {
        String lastVersion = bizConfigProperties.getInviteAndriodApkUrl();
        String fileName = StringUtils.substringAfterLast(lastVersion, "/");

        String separator = StringUtils.EMPTY;
        if (!this.bizConfigProperties.getTempDir().endsWith("/") &&
                !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }

        File appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName);

        if (appFile.exists()) {
            return appFile;
        }

        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists()) {
            boolean result = tempDirFile.mkdirs();
            if (!result) {
                this.logger.error("创建[{}]目录失败，可能没有权限", this.bizConfigProperties.getTempDir());
            }
        }

        try {
            FileUtils.copyURLToFile(new URL(lastVersion), appFile);
        } catch (IOException e) {
            this.logger.error("参数[common.config.invite-andriod-apk-url]配置的安卓下载文件路径不正确", e);
        }

        return appFile;
    }

}