package com.bxm.localnews.thirdparty.controller;

import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.config.ThirdPartyProperties;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.BannerService;
import com.bxm.localnews.thirdparty.vo.Advert;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-03 banner接口", description = "banner相关操作")
@RequestMapping("/api")
@RestController
public class BannerController {

    @Resource
    private BannerService bannerService;

    @Resource
    private AdvertService advertService;

    @Resource
    private ThirdPartyProperties thirdPartyProperties;

    @Autowired
    public BannerController(BannerService bannerService, AdvertService advertService) {
        this.bannerService = bannerService;
        this.advertService = advertService;
    }

    @ApiOperation(value = "3-03-1 获取广告位信息")
    @ApiImplicitParam(name = "type", value = "类型", required = true)
    @RequestMapping(value = "advert/query", method = RequestMethod.GET)
    public Json<List<Advert>> getAdverts(@RequestParam(value = "type", required = true) Byte type) {
        /*List<Advert> data = new ArrayList<>(3);
        List<Advert> list = this.advertService.queryAdByType(type, null);
        Random random = new Random();
        if (type.equals(BannerEunm.MYMESSAGE_AD.getType()) || type.equals(BannerEunm.SUSPEND_AD.getType())) {
            if (!ObjectUtils.isEmpty(list)) {
                Advert advert = list.get(random.nextInt(list.size()));
                data.add(advert);
                return ResultUtil.genSuccessResult(data);
            }
        } else if (type.equals(BannerEunm.POPUP_AD.getType())) {
            if (thirdPartyProperties.isShowPopAdvert()) {
                if (!ObjectUtils.isEmpty(list)) {
                    Advert advert = list.get(random.nextInt(list.size()));
                    data.add(advert);
                    return ResultUtil.genSuccessResult(data);
                }
            }
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genSuccessResult(list);*/

        return null;
    }

}

