package com.bxm.localnews.thirdparty.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.service.CrmSendMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.wxmessage.MediaContent;
import com.bxm.localnews.thirdparty.wxmessage.Message;
import com.bxm.localnews.thirdparty.wxmessage.MsgConfig;
import com.bxm.localnews.thirdparty.wxmessage.TextContent;
import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.SHA1;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value = "api/public/callBack")
@ApiIgnore
public class CallBackController {
    private Logger LOG = LoggerFactory.getLogger(CallBackController.class);

    @Autowired
    private WechatProperties wechatProperties;

    @Autowired
    private WechatService wechatService;

    @Autowired
    private CrmSendMessageService crmSendMessageService;

//    @RequestMapping(value = "", method = RequestMethod.GET)
//    public String checkToken(@RequestParam String signature,
//                             @RequestParam String timestamp,
//                             @RequestParam String nonce,
//                             @RequestParam String echostr) {
//        if (checkToken(signature, timestamp, nonce, false)) {
//            return echostr;
//        } else {
//            return "";
//        }
//    }


    @ApiOperation(value = "接收客服消息", notes = "接收客服消息并自动回复")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public String callBack(@RequestBody JSONObject body) throws Exception {
        String fromUserName = body.getString("FromUserName");
        LOG.info("客服消息发送 fromUserName:{}", fromUserName);

        String msgId = body.getString("MsgId");
        if (StringUtils.isNotBlank(msgId)) {
            // 默认客服消息
            sendMessage(fromUserName, "戳链接下载App，立即提现"
                    + wechatProperties.getDownloadUrl() + "，更多现金红包等你来领", null);
        }

        return "";
    }

    private void sendMessage(String FromUserName, String textContent, String imageId) throws Exception {
        // 回复文本
        Message messageText = new Message();
        TextContent text = new TextContent();
        text.setContent(textContent);
        messageText.setMsgtype(MsgConfig.TEXT);
        messageText.setText(text);
        messageText.setTouser(FromUserName);
        crmSendMessageService.sendMessageOfText(wechatService.getWeChatToken(), messageText);

        // 回复图片
        if (StringUtils.isNotBlank(imageId)) {
            Message messageImg = new Message();
            MediaContent image = new MediaContent();
            image.setMedia_id(imageId);
            messageImg.setMsgtype(MsgConfig.IMAGE);
            messageImg.setTouser(FromUserName);
            messageImg.setImage(image);
            crmSendMessageService.sendMessageOfImg(wechatService.getWeChatToken(), messageImg, null);
        }
    }

    public boolean checkToken(String signature, String timestamp, String nonce, boolean hasEncrypt) {
        String result = "";
        if (hasEncrypt) {
            try {
                result = SHA1.getSHA1(MsgConfig.MNP_TOKEN, timestamp, nonce, MsgConfig.EncodingAESKey);
            } catch (AesException e) {
                e.printStackTrace();
            }
        } else {
            try {
                result = SHA1.getSHA1(MsgConfig.MNP_TOKEN, timestamp, nonce);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (result.equals(signature)) {
            return true;
        } else {
            return false;
        }
    }
}
