package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.EnjoyBaseDTO;
import com.bxm.localnews.thirdparty.dto.EnjoyDetailDTO;
import com.bxm.localnews.thirdparty.service.EnjoyEatService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2018/10/30 16:01
 * @desc
 */
@Api(tags = "3-13 吃喝玩乐相关接口", description = "提供吃喝玩乐相关接口操作")
@RestController
@RequestMapping("api/public/enjoy")
public class EnjoyEatController {

    private EnjoyEatService enjoyEatService;

    @Autowired
    public EnjoyEatController(EnjoyEatService enjoyEatService) {
        this.enjoyEatService = enjoyEatService;
    }

    @ApiOperation(value = "获取吃喝玩乐的数据", notes = "如果返回的enjoyList或者eatList为空数组，则不显示")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码"),
    })
    @GetMapping("/index")
    public Json<EnjoyBaseDTO> getEnjoyDTOByAreaCode(String areaCode) {
        return ResultUtil.genSuccessResult(this.enjoyEatService.getEnjoyBaseDTOByCode(areaCode));
    }

    @ApiOperation(value = "根据id获取对应详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "对应点击的id")
    })
    @GetMapping("/detail")
    public Json<EnjoyDetailDTO> getEnjoyDetailDTOById(Long id) {
        return ResultUtil.genSuccessResult(this.enjoyEatService.getEnjoyDetailDTO(id));
    }
}
