package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.bxm.localnews.common.constant.RedisConfig.MACHINE_SCAN_COUNT;

@Api(tags = "3-05 机器二维码短链接", description = "获取机器二维码相关操作")
@RestController
@RequestMapping("m")
public class MachineShortLinkController extends BaseController {

    private ShortLinkService shortLinkService;

    private RedisStringAdapter redisStringAdapter;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public MachineShortLinkController(ShortLinkService shortLinkService, RedisStringAdapter redisStringAdapter,
                                      BizConfigProperties bizConfigProperties) {
        this.shortLinkService = shortLinkService;
        this.redisStringAdapter = redisStringAdapter;
        this.bizConfigProperties = bizConfigProperties;
    }

    @GetMapping("get")
    @ApiOperation(value = "3-05-1 获取机器上二维码的短链接", notes = "根据机器唯一标识码获取对应的短链接")
    @ApiImplicitParam(name = "machineId", value = "机器id", required = true)
    public String getShortLink(@RequestParam String machineId) {
        return shortLinkService.getMachineShortLink(machineId);
    }

    @ApiOperation(value = "3-05-2 获取短链接跳转地址并转发", notes = "记录机器扫描下载的次数")
    @ApiImplicitParam(name = "key", value = "短链接", required = true)
    @GetMapping(value = {"/{key}"})
    public void getUrl(@PathVariable String key, HttpServletResponse resp) throws IOException {

        KeyGenerator shortKey = RedisConfig.MACHINE_SHORT_URL_KEY.copy().setKey(key);

        String machineId = this.redisStringAdapter.get(shortKey, String.class);
        //记录machineId访问记录
        long val = redisStringAdapter.increment(MACHINE_SCAN_COUNT.copy().setKey(machineId));
        logger.info("扫描下载次数：" + val);

        //key不存在，则默认注册页面
        String h5Root = bizConfigProperties.getH5ServerHost();
        resp.sendRedirect(h5Root + "/download.html");
    }

}
