package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.oss.dto.OSSToken;
import com.bxm.newidea.component.oss.service.AliyunOssTokenService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/4/9 17:10
 * @desc
 */
@Api(tags = "3-17 oss-token接口", description = "ossToken生成接口相关操作")
@RestController
@RequestMapping("api/public/oss")
public class OssTokenController {

    @Autowired
    private AliyunOssTokenService aliyunOssTokenService;

    @ApiOperation(value = "3-17-1 获取ossToken，有效期半个小时", notes = "获取ossToken")
    @GetMapping("/token")
    public Json<OSSToken> getRandomDomain() {
        return ResultUtil.genSuccessResult(aliyunOssTokenService.getOssToken());
    }
}
