package com.bxm.localnews.thirdparty.controller;

import javax.servlet.http.HttpServletRequest;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.newidea.component.util.WebUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "3-15 微信小程序相关接口")
@RestController
@RequestMapping("api/public/wechat")
public class WechatAppletController {

    @Autowired
    private WechatService wechatService;

    @ApiOperation(value = "3-15-1 获取微信的openid及session_key")
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public Json<WxUserInfo> getWechatInfo(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult(wechatService.getWechatInfo(wechatDto));
    }

    @ApiOperation(value = "3-15-2 获取微信小程序二维码接口")
    @RequestMapping(value = "/qrcode", method = RequestMethod.GET)
    public Json<String> getWechatQRCode(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult(wechatService.getWechatQRCode(wechatDto));
    }

    @ApiOperation(value = "3-15-3 解密数据，创建账号，返回userId")
    @RequestMapping(value = "/createUser", method = RequestMethod.GET)
    public Json<String> createUser(WxMaUserData wxMaUserData, HttpServletRequest request) {
        wxMaUserData.setIp(WebUtils.getIpAddr(request));
        return ResultUtil.genSuccessResult(wechatService.createUser(wxMaUserData));
    }

    @ApiOperation(value = "3-15-4 存储用户formId")
    @RequestMapping(value = "/setUserFormId", method = RequestMethod.POST)
    public Json<Boolean> setUserFormId(@RequestParam(value = "userId") Long userId,
                                       @RequestParam(value = "formId") String formId,
                                       @RequestParam(value = "appId", required = false) String appId) {
        return ResultUtil.genSuccessResult(wechatService.setUserFormId(userId, formId, appId));
    }

    @ApiOperation(value = "3-15-5 对应小程序的openId是否弹窗")
    @ApiImplicitParams({

            @ApiImplicitParam(name = "openId", value = "小程序openId"),
            @ApiImplicitParam(name = "platform", value = "平台信息 1：安卓 2：IOS 3：H5 4:转盘 5：万事通",
                    allowableValues = "1,2,3,4,5", required = true)
    })
    @RequestMapping(value = "/popup", method = RequestMethod.GET)
    public Json<Boolean> userPopup(@RequestParam(value = "openId") String openId,
                                   @RequestParam(value = "platform") Integer platform) {
        return ResultUtil.genSuccessResult(wechatService.userPopup(openId, platform));
    }
}
