package com.bxm.localnews.thirdparty.controller;


import com.bxm.localnews.thirdparty.advert.AdvertCallbackService;
import com.bxm.localnews.thirdparty.param.AiqiyiAdvertCallbackParam;
import com.bxm.localnews.thirdparty.param.BaiduAdvertCallbackParam;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-18 广告平台回调处理", description = "第三方广告平台触发回调处理，暂不存在消费行为")
@RestController
@RequestMapping("api/thirdparty/public/advert")
@Controller
public class AdvertCallbackController extends BaseController {

    private final AdvertCallbackService advertCallbackService;

    @Autowired
    public AdvertCallbackController(AdvertCallbackService advertCallbackService) {
        this.advertCallbackService = advertCallbackService;
    }

    @RequestMapping("baidu")
    public void baidu(BaiduAdvertCallbackParam param) {
        advertCallbackService.baiduCallback(param);
    }

    @RequestMapping("aiqiyi")
    public void aiqiyi(AiqiyiAdvertCallbackParam param) {
        advertCallbackService.aiqiyiCallback(param);
    }
}
