package com.bxm.localnews.thirdparty.controller.facade;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/6/12 15:41
 * @desc
 */
@Api(tags = "3-98 [内部接口]推送模板消息接口", description = "模板消息推送相关操作")
@RestController
@RequestMapping("facade/template")
public class PushTemplateMessageFacadeController {

    @Autowired
    private PushMessageService pushMessageService;

    @ApiOperation(value = "3-98-1 推送模板消息", notes = "推送模板消息")
    @ApiImplicitParams({

            @ApiImplicitParam(name = "appId", value = "小程序appId: 传空则发送万事通小程序模板消息", paramType = "query", dataType = "String")
    })

    @PostMapping("/push")
    public ResponseEntity<Message> pushTemplateMessage(@RequestBody PushMessage pushMessage,
                                                       @RequestParam(value = "appId", required = false) String appId) {
        pushMessageService.pushTemplateMessage(pushMessage, appId);
        return ResponseEntity.ok(Message.build());
    }

    @ApiOperation(value = "3-98-2 推送公众号模板消息", notes = "推送公众号模板消息", nickname = "耿杨杨")
    @PostMapping("/pushOfficialAccountMsg")
    public ResponseEntity<Message> pushOfficialAccountMsg(@RequestBody WechatMpPushMessage wechatMpPushMessage) {
        return ResponseEntity.ok(pushMessageService.pushOfficialAccountMsg(wechatMpPushMessage));
    }
}
