package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.thirdparty.param.GuideCloseParam;
import com.bxm.localnews.thirdparty.param.GuideStatusParam;
import com.bxm.localnews.thirdparty.service.GuidePopService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 *
 * @author Gonzo
 * @date  2020-08-21 14:34
 */
@Api(tags = "3-24 引导弹窗相关接口", description = "获取引导弹窗的开启状态、上报关闭等等")
@RestController
@RequestMapping("{version}/thirdparty/guidePop")
@Slf4j
@AllArgsConstructor
public class GuidePopController {

    private final GuidePopService guidePopService;

    @ApiOperation(value = "3-24-1 [v1] 引导弹窗的开启状态  true: 未弹出，需要弹窗 false: 已弹出 不允许弹窗")
    @GetMapping("guideStatus")
    @ApiVersion(1)
    public ResponseJson<Boolean> guideStatus(GuideStatusParam param) {
        return ResponseJson.ok(guidePopService.guideStatus(param));
    }

    @ApiOperation(value = "3-24-2 [v1] 引导弹窗关闭上报")
    @GetMapping("guideClose")
    @ApiVersion(1)
    public ResponseJson<Boolean> guideClose(GuideCloseParam param) {
        guidePopService.guideClose(param);
        return ResponseJson.ok(Boolean.TRUE);
    }
}
