package com.bxm.localnews.thirdparty.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import com.bxm.localnews.thirdparty.service.PayKnowledgeService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-06 知识付费相关接口", description = "知识付费相关接口")
@RestController
@RequestMapping("/api/public/knowledge")
public class PayKnowledgeController {

    private PayKnowledgeService payKnowledgeService;

    @Autowired
    public PayKnowledgeController(PayKnowledgeService payKnowledgeService) {
        this.payKnowledgeService = payKnowledgeService;
    }

    @ApiOperation(value = "3-06-1 知识付费首页免登陆url", notes = "请求该接口，直接重定向到相应的跳转地址")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "isLogin", value = "0表示未登录，1表示已登陆", dataType = "String", required = true),
            @ApiImplicitParam(name = "redirectUrl", value = "重定向的地址", dataType = "String")
    })
    @RequestMapping(value = "/exempt/login", method = RequestMethod.GET)
    public void exemptKnowledgeLogin(@RequestParam(value = "userId") Long userId, Integer isLogin,
                                     @RequestParam(required = false) String redirectUrl,
                                     HttpServletResponse response) throws IOException {
        if(userId != null){
            response.sendRedirect(this.payKnowledgeService.exemptPayKnowledgeLogin(userId, isLogin, redirectUrl));
        }
    }
}
