package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.CalendarDTO;
import com.bxm.localnews.thirdparty.service.PerpetualCalendarService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-07 万年历查询", description = "万年历查询")
@RestController
@RequestMapping("api/public/calendar")
public class PerpetualCalendarController {

    private PerpetualCalendarService perpetualCalendarService;

    @Autowired
    public PerpetualCalendarController(PerpetualCalendarService perpetualCalendarService){
        this.perpetualCalendarService = perpetualCalendarService;
    }

    @ApiOperation(value = "3-07-1 查询当天的万年历", notes = "")
    @RequestMapping(value = "/today", method = RequestMethod.GET)
    public Json<CalendarDTO> selectCalendar() {
        return ResultUtil.genSuccessResult(this.perpetualCalendarService.getTodayCalendar());
    }

}
