package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.thirdparty.param.RedirectToWechatMpAuthParam;
import com.bxm.localnews.thirdparty.service.impl.WechatMpService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 微信公众号相关功能接口
 * @author gonzo
 * @date 2020-07-30 17:29
 **/
@Api(tags = "3-23 微信公众号相关功能接口", description = "如：微信授权地址获取")
@RestController
@RequestMapping("{version}/thirdparty/wechatMp")
@Controller
@AllArgsConstructor
public class WechatMpController {

    private final WechatMpService wechatMpService;

    @ApiOperation(value = "3-23-1 组装并重定向到微信授权页面", notes = "根据请求参数，选用中间页域名，组装并重定向到微信授权页面")
    @GetMapping("auth")
    @ApiVersion(1)
    public ResponseJson<String > redirectToWechatMpAuth(RedirectToWechatMpAuthParam param, HttpServletResponse response) throws IOException {
        // 获取地址，并重定向
        // response.sendRedirect(wechatMpService.wechatMpAuthUrlGen(param));
        if (param.isDoRedirect()) {
            response.sendRedirect(wechatMpService.wechatMpAuthUrlGen(param));
            return ResponseJson.ok().build();
        } else {
            return ResponseJson.ok(wechatMpService.wechatMpAuthUrlGen(param));
        }
    }

}
