package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.thirdparty.dto.XiaojuAuthDTO;
import com.bxm.localnews.thirdparty.dto.XiaojuLinkDTO;
import com.bxm.localnews.thirdparty.param.XiaojuAuthParam;
import com.bxm.localnews.thirdparty.service.XiaojuService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: pf.w
 * @Date: 2020/5/23 11:52
 */
@Api(tags = "3-20 小桔加油相关接口 【占个位】", description = "小桔加油相关接口")
@RestController
@RequestMapping("thirdparty/public/xiaoju")
@Slf4j
public class XiaoJuController {

    @Autowired
    private XiaojuService xiaojuService;

    @PostMapping("user/auth")
    @ApiOperation(value = "3-20-01 获得链接", notes = "根据手机号获得小桔加油链接")
    public ResponseJson<XiaojuLinkDTO> getXiaojuLink(@RequestBody XiaojuAuthParam xiaojuAuthParam) {
        Message m = xiaojuService.getXiaojuLink(xiaojuAuthParam);
        if (m.isSuccess()) {
            return ResponseJson.ok(m.getParam("xiaojuLinkDTO"));
        }
        return ResponseJson.ok(null);
    }

    @GetMapping("/oauthcode/get")
    @ApiOperation(value = "3-20-02 获得oauthcode", notes = "根据手机号获取oauthcode")
    public ResponseEntity<XiaojuAuthDTO> getOauthcode(String encryptPhone) {
        Message m = xiaojuService.getOauthcode(encryptPhone);
        if (m.isSuccess()) {
            return ResponseEntity.ok(m.getParam("xiaojuAuthDTO"));
        }
        return ResponseEntity.badRequest().build();

    }
}
