package com.bxm.localnews.thirdparty.controller.facade;

import com.bxm.localnews.thirdparty.service.WechatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "3-100 [内部接口] 调用微信敏感词库")
@RestController
@RequestMapping("facade/wechat")
@Slf4j
public class WechatFacadeController {

	private final WechatService wechatService;

	@Autowired
	public WechatFacadeController(WechatService wechatService){
		this.wechatService = wechatService;
	}

	@ApiOperation(value = "3-100-1 查看内容是否包含敏感词", notes = "true包含, false不含")
	@GetMapping("/hasSensitiveWord")
	public ResponseEntity<Boolean>  getWechatAccessToken(@RequestParam(value = "content") String content){
		 return  new ResponseEntity(wechatService.hasSensitiveWord(content),HttpStatus.OK);
	}
}
