/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.ClassificationDTO;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.AdvertParam;
import com.bxm.localnews.thirdparty.param.AdvertisementApiParam;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.AppParam;
import com.bxm.localnews.thirdparty.param.DeviceParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.PopService;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-01 \u5e7f\u544a\u63a5\u53e3"}, description="\u5e7f\u544a\u63a5\u53e3\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/public/advert"})
public class AdvertController {
    private static final Logger log = LoggerFactory.getLogger(AdvertController.class);
    private AdvertService advertService;
    private PopService popService;
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    public AdvertController(AdvertService advertService, PopService popService, RedisSetAdapter redisSetAdapter) {
        this.advertService = advertService;
        this.popService = popService;
        this.redisSetAdapter = redisSetAdapter;
    }

    @ApiOperation(value="3-01-1 \u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5e7f\u544a")
    @GetMapping(value={"/type"})
    public Json<List<AdvertVO>> getAdvertsByType(AdvertisementApiParam apiParam) {
        AdvertisementParam param = new AdvertisementParam();
        BeanUtils.copyProperties((Object)apiParam, (Object)param);
        return ResultUtil.genSuccessResult((Object)this.advertService.queryAdByType(param));
    }

    @ApiOperation(value="3-01-2 \u83b7\u53d6\u9996\u9875\u5f39\u7a97")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true), @ApiImplicitParam(name="areaName", value="\u5730\u533a\u540d", required=false), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @GetMapping(value={"/homeWindow"})
    public Json<HomeWindowDTO> getHomeWindow(HomeWindowParam homeWindowParam, HttpServletRequest request) {
        KeyGenerator k = RedisConfig.IS_NEED_RE_LOGIN.copy();
        if ("3.1.2".equals(homeWindowParam.getCurVer())) {
            log.info("3.1.2\u7684\u7528\u6237\u8fdb\u884c\u5224\u65ad\u662f\u5426\u5df2\u767b\u5f55");
            if (Objects.equals(Boolean.FALSE, this.redisSetAdapter.exists(k, (Object)homeWindowParam.getUserId()))) {
                log.info("3.1.2\u7684\u7528\u6237\u8fdb\u884c\u5224\u65ad\u662f\u5426\u5df2\u767b\u5f55\uff0c\u5982\u679c\u6ca1\u6709\u767b\u5f55\u7684\u75d5\u8ff9\uff0c\u5219\u8ba9\u7528\u6237\u91cd\u65b0\u767b\u9646");
                return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)"\u767b\u5f55\u5931\u6548");
            }
        } else if (Objects.equals(Boolean.TRUE, this.redisSetAdapter.exists(k, (Object)homeWindowParam.getUserId()))) {
            this.redisSetAdapter.remove(k, new Object[]{homeWindowParam.getUserId()});
        }
        homeWindowParam.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        return ResultUtil.genSuccessResult((Object)this.popService.getHomeWindow(homeWindowParam));
    }

    @ApiOperation(value="3-01-3 VIP\u5f00\u5361\u6743\u76ca\u9875-\u5168\u90e8\u5206\u7c7b", notes="VIP\u5f00\u5361\u6743\u76ca\u9875-\u5168\u90e8\u5206\u7c7b")
    @GetMapping(value={"/classification"})
    public ResponseJson<List<ClassificationDTO>> listVipClassification(AdvertParam param) {
        return ResponseJson.ok((Object)this.advertService.vipPageClassificationList(param));
    }

    @ApiOperation(value="3-01-4 \u6839\u636e\u7c7b\u578b\u548c\u6295\u653eid\u96c6\u5408\u83b7\u53d6\u5e7f\u544a")
    @GetMapping(value={"/typeIds"})
    public Json<List<AdvertVO>> getAdvertsByTypeIds(AdvertisementApiParam apiParam, AppParam app, DeviceParam device) {
        AdvertisementParam param = new AdvertisementParam();
        BeanUtils.copyProperties((Object)apiParam, (Object)param);
        param.setApp(app);
        param.setDevice(device);
        return ResultUtil.genSuccessResult((Object)this.advertService.queryAdByTypeIds(param));
    }
}

