/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-05 \u673a\u5668\u4e8c\u7ef4\u7801\u77ed\u94fe\u63a5"}, description="\u83b7\u53d6\u673a\u5668\u4e8c\u7ef4\u7801\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"m"})
public class MachineShortLinkController
extends BaseController {
    private ShortLinkService shortLinkService;
    private RedisStringAdapter redisStringAdapter;
    private BizConfigProperties bizConfigProperties;
    private BaseUrlFacadeService baseUrlFacadeService;

    @GetMapping(value={"get"})
    @ApiOperation(value="3-05-1 \u83b7\u53d6\u673a\u5668\u4e0a\u4e8c\u7ef4\u7801\u7684\u77ed\u94fe\u63a5", notes="\u6839\u636e\u673a\u5668\u552f\u4e00\u6807\u8bc6\u7801\u83b7\u53d6\u5bf9\u5e94\u7684\u77ed\u94fe\u63a5")
    @ApiImplicitParam(name="machineId", value="\u673a\u5668id", required=true)
    public String getShortLink(@RequestParam String machineId) {
        return this.shortLinkService.getMachineShortLink(machineId);
    }

    @ApiOperation(value="3-05-2 \u83b7\u53d6\u77ed\u94fe\u63a5\u8df3\u8f6c\u5730\u5740\u5e76\u8f6c\u53d1", notes="\u8bb0\u5f55\u673a\u5668\u626b\u63cf\u4e0b\u8f7d\u7684\u6b21\u6570")
    @ApiImplicitParam(name="key", value="\u77ed\u94fe\u63a5", required=true)
    @GetMapping(value={"/{key}"})
    public void getUrl(@PathVariable String key, HttpServletResponse resp) throws IOException {
        KeyGenerator shortKey = RedisConfig.MACHINE_SHORT_URL_KEY.copy().setKey(key);
        String machineId = (String)this.redisStringAdapter.get(shortKey, String.class);
        long val = this.redisStringAdapter.increment(RedisConfig.MACHINE_SCAN_COUNT.copy().setKey(machineId));
        this.logger.info("\u626b\u63cf\u4e0b\u8f7d\u6b21\u6570\uff1a" + val);
        resp.sendRedirect(this.baseUrlFacadeService.getContentViewSceneBaseUrl() + "/download.html");
    }

    public MachineShortLinkController(ShortLinkService shortLinkService, RedisStringAdapter redisStringAdapter, BizConfigProperties bizConfigProperties, BaseUrlFacadeService baseUrlFacadeService) {
        this.shortLinkService = shortLinkService;
        this.redisStringAdapter = redisStringAdapter;
        this.bizConfigProperties = bizConfigProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
    }
}

