/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-15 \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"api/public/wechat"})
public class WechatAppletController {
    @Autowired
    private WechatService wechatService;

    @ApiOperation(value="3-15-1 \u83b7\u53d6\u5fae\u4fe1\u7684openid\u53casession_key")
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public Json<WxUserInfo> getWechatInfo(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult((Object)this.wechatService.getWechatInfo(wechatDto));
    }

    @ApiOperation(value="3-15-2 \u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u63a5\u53e3")
    @RequestMapping(value={"/qrcode"}, method={RequestMethod.GET})
    public Json<String> getWechatQRCode(@ModelAttribute WechatDto wechatDto) {
        return ResultUtil.genSuccessResult((Object)this.wechatService.getWechatQRCode(wechatDto));
    }

    @ApiOperation(value="3-15-3 \u89e3\u5bc6\u6570\u636e\uff0c\u521b\u5efa\u8d26\u53f7\uff0c\u8fd4\u56deuserId")
    @RequestMapping(value={"/createUser"}, method={RequestMethod.GET})
    public Json<String> createUser(WxMaUserData wxMaUserData, HttpServletRequest request) {
        wxMaUserData.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        return ResultUtil.genSuccessResult((Object)this.wechatService.createUser(wxMaUserData));
    }

    @ApiOperation(value="3-15-4 \u5b58\u50a8\u7528\u6237formId")
    @RequestMapping(value={"/setUserFormId"}, method={RequestMethod.POST})
    public Json<Boolean> setUserFormId(@RequestParam(value="userId") Long userId, @RequestParam(value="formId") String formId, @RequestParam(value="appId", required=false) String appId) {
        return ResultUtil.genSuccessResult((Object)this.wechatService.setUserFormId(userId, formId, appId));
    }

    @ApiOperation(value="3-15-5 \u5bf9\u5e94\u5c0f\u7a0b\u5e8f\u7684openId\u662f\u5426\u5f39\u7a97")
    @ApiImplicitParams(value={@ApiImplicitParam(name="openId", value="\u5c0f\u7a0b\u5e8fopenId"), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5 4:\u8f6c\u76d8 5\uff1a\u4e07\u4e8b\u901a", allowableValues="1,2,3,4,5", required=true)})
    @RequestMapping(value={"/popup"}, method={RequestMethod.GET})
    public Json<Boolean> userPopup(@RequestParam(value="openId") String openId, @RequestParam(value="platform") Integer platform) {
        return ResultUtil.genSuccessResult((Object)this.wechatService.userPopup(openId, platform));
    }

    @ApiOperation(value="3-15-6 \u83b7\u53d6\u7528\u6237\u624b\u673a\u53f7")
    @RequestMapping(value={"/getUserPhoneNum"}, method={RequestMethod.GET})
    public Json<WxMaPhoneNumberInfo> getUserPhoneNum(WxMaUserData wxMaUserData) {
        return ResultUtil.genSuccessResult((Object)this.wechatService.getUserPhoneNum(wxMaUserData));
    }
}

