/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller.facade;

import com.bxm.localnews.thirdparty.advert.AdvertCallbackService;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-99 [\u5185\u90e8\u63a5\u53e3]\u5e7f\u544a\u63a5\u53e3"}, description="\u5e7f\u544a\u63a5\u53e3\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"facade/advert"})
public class AdvertFacadeController {
    private final AdvertService advertService;
    private final AdvertCallbackService advertCallbackService;

    @Autowired
    public AdvertFacadeController(AdvertService advertService, AdvertCallbackService advertCallbackService) {
        this.advertService = advertService;
        this.advertCallbackService = advertCallbackService;
    }

    @ApiOperation(value="3-99-1 \u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5e7f\u544a", notes="type\u5e7f\u544a\u7c7b\u578b 1:\u9996\u9875\u5f39\u7a97\u5e7f\u544a 2:\u65e5\u5e38\u4efb\u52a1\u5e7f\u544a 7:\u5f00\u5c4f\u5e7f\u544a 3\uff1a\u8f6e\u64ad\u5e7f\u544a 4\uff1a\u4e2a\u4eba\u4e2d\u5fc3\u8f6e\u64ad\u5e7f\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u5e7f\u544a\u7c7b\u578b", allowableValues="1,2,3,4,5,6,7,8,9,10,11", dataType="String", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", paramType="query", dataType="String")})
    @GetMapping(value={"/type"})
    public ResponseEntity<List<AdvertVO>> getAdvertsByType(@RequestParam String type, @RequestParam(required=false) String areaCode, @RequestParam(required=false) Long userId) {
        return ResponseEntity.ok((Object)this.advertService.queryAdByType(Byte.valueOf(type), areaCode, userId, null));
    }

    @ApiOperation(value="3-99-2 \u7528\u6237\u6ce8\u518c\u6210\u529f\u65f6\uff0c\u89e6\u53d1\u5e7f\u544a\u56de\u8c03", notes="\u89e6\u53d1\u5e7f\u544a\u56de\u8c03")
    @ApiImplicitParam(name="androidId", value="\u5b89\u5353ID")
    @PostMapping(value={"trigger/advert"})
    public ResponseEntity<Boolean> triggerAdvert(@RequestParam String androidId) {
        return ResponseEntity.ok((Object)this.advertCallbackService.triggerCallback(androidId));
    }
}

