package com.bxm.localnews.thirdparty.constant;

/**
 * Created by Administrator on 2018/3/29.
 */
public enum AdvertTypeEnum {

    /**
     * 首页弹窗广告
     */
    INDEX_POP_WINDOW(1, "首页弹窗广告"),
    DAILY_TASK(2, "日常任务广告"),
    TURN_AROUND_ADVERT(3, "轮播广告"),
    TURN_AROUND_PERSONAL_CENTER(4, "个人中心轮播广告"),
    START_SCREEN(7, "开屏广告"),
    INDEX_CONFIG(8, "首页配置广告"),
    TURN_AROUND_SIGN_IN(9, "签到页面-轮播广告"),
    TURN_AROUND_MESSAGE_CENTER(10, "消息中心轮播广告"),
    COMMUNITY_INDEX_CONTENT(11, "社区首页广告"),


    PUBLISH_SUC_BOTTOM(16, "发布成功底部广告位"),
    PUBLISH_SUSPEND(22, "发布成功悬浮广告"),

    NEWS_DETAIL_BANNER(23, "站内新闻内容详情广告位"),
    POST_DETAIL_BANNER(24, "站内帖子内容详情广告位"),

    POST_SHARE_SUSPEND(18, "站外帖子分享页-悬浮广告"),
    POST_SHARE_BANNER(20, "站外帖子分享页-banner广告"),

    NEWS_SHARE_SUSPEND(19, "站外新闻分享页-悬浮广告"),
    NEWS_SHARE_BANNER(21, "站外新闻分享页-banner广告"),

    VIP_PAGE_BALL_ADVERT(25, "VIP主页-球区广告"),
    VIP_PAGE_TOP_BANNER(26, "VIP主页-顶部banner"),
    VIP_CENTER_SCROLL(58, "VIP主页-文字滚动"),
    VIP_CENTER_HOT(59, "VIP主页-热门优惠"),
    VIP_PAGE_MERCHANT(27, "VIP主页-特惠商家"),
    OUT_FORUM(43, "VIP资源位广告"),


    MERCHAR_ACTIVITY(42, "活动模板banner"),
    MY_TOP_BANNER(64, "我的顶部模块-icon"),


    TOUTIAO_ADVERT_FIRST(44, "头条信息流广告位【first】"),
    TOUTIAO_ADVERT_SECOND(45, "头条信息流广告位【second】"),
    TOUTIAO_ADVERT_THIRD(46, "头条信息流广告位【third】"),
    INDEX_TOOL_AREA(60, "头条球区广告位"),

    BENDIQUAN_ADVERT_FIRST(47, "本地圈广告【first】"),
    BENDIQUAN_ADVERT_SECOND(48, "本地圈广告【second】"),

    SEACH_BOX_ADVERT(49, "搜索页面-搜索框"),
    SEACH_HOTWORD_ADVERT(50, "搜索页面-热词"),

    SHARE_POSTER(51, "我要收徒-收徒海报"),

    TOPIC_LOCATION_ADVERT_BANNER(52, "栏目话题-banner"),
    TOPIC_LOCATION_ADVERT_BALL(53, "栏目话题-球区"),
    TOPIC_LOCATION_SUSPEND(61, "栏目话题-悬浮广告位"),

    MERCHANT_CENTER(56, "商家中心"),
    BIANMING(54, "便民栏目-banner"),
    BIANMING_SUB(55, "便民子栏目-banner"),

    VIP_CARD_PAGE_ZJTQ(29, "已开卡权益页面-最近特权"),
    VIP_CARD_PAGE_RMTQ(30, "已开卡权益页面-热门特权"),
    VIP_CARD_PAGE_YYWL(31, "已开卡权益页面-影音娱乐"),
    VIP_CARD_PAGE_MSCY(32, "已开卡权益页面-美食餐饮"),
    VIP_CARD_PAGE_FLSC(33, "已开卡权益页面-返利商场"),
    VIP_CARD_PAGE_DPFL(34, "已开卡权益页面-大牌返利"),
    VIP_CARD_PAGE_CSGW(35, "已开卡权益页面-超时购物"),
    VIP_CARD_PAGE_LLCX(36, "已开卡权益页面-旅游出行"),
    VIP_CARD_PAGE_DSXX(37, "已开卡权益页面-读书学习"),
    VIP_CARD_PAGE_SHFW(38, "已开卡权益页面-生活服务"),
    VIP_CARD_PAGE_CZFW(39, "已开卡权益页面-车主福利"),
    VIP_CARD_PAGE_YHJK(40, "已开卡权益页面-医护健康"),
    VIP_CARD_PAGE_MFZQ(41, "已开卡权益页面-免费专区"),

    @Deprecated
    CONVENIENCE_CENTER(17, "便民中心广告位"),

    INVITE_CODE_BANNER(57, "邀请码激活海报"),
    INVITE_POSTER_SHARE(62, "邀请好友海报分享"),

    IOS_RED_PACKET(12, "IOS红包墙广告位"),
    MINI_PROGRAM_INDEX_BANNER(13, "小程序首页banner"),
    MINI_PROGRAM_SUSPEND(14, "小程序悬浮广告"),
    MINI_PROGRAM_POP_WINDOW(15, "小程序首页弹窗广告"),
    MERCHANT_PAGE_TOP_BANNER(28, "特惠商家列表顶部banner广告位"),

    OUT_DOWNLOAD_BANNER(63, "站外帖子顶部下载区域"),

    MERCHANT_CENTER_MSG(65,"商家中心轮播消息广告位"),

    TOP_SHOWCASE(66,"头条橱窗"),
    SIGN_PAGE_BANNER(67,"签到页banner"),


    LOTTERY_DOWNLOAD_BANNER(68, "万事通下载页（夺宝素材）"),

    TAOBEO_SAVE_MONEY_BANNER(69, "淘宝省钱banner"),

    TALENT_GROUP_BANNER(70, "达人发展团队banner"),

    INVITE_TALENT_POSTER(71, "邀请达人海报"),

    H5_MORE_WELFARE(72, "站外我的更多福利banner"),

    H5_MY_PAGE(73, "站外我的页面"),

    H5_MEMBER_DAY_MALL(74, "会员日页商城广告位"),

    H5_GOODS_INFO(75, "会员日商品详情页广告位"),

    ;
    // 当前最大值：75


    private int type;

    private String desc;

    AdvertTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdvertTypeEnum getByPosition(int position) {
        AdvertTypeEnum[] postions = AdvertTypeEnum.values();

        for (AdvertTypeEnum positionType : postions) {
            if (position == positionType.getType()) {
                return positionType;
            }
        }

        return null;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
