package com.bxm.localnews.thirdparty.constant;

import lombok.Getter;

/**
 * 意见反馈类型
 *
 * @author wzy
 * @date 2020/8/13 18:24
 **/
@Getter
public enum FeedbackTypeEnum {
    /**
     * 产品建议
     */
    PRODUCT_ADVICE(1, "产品建议"),

    /**
     * 问题反馈
     */
    PROBLEM_FEEDBACK(2, "问题反馈"),

    /**
     * 举报投诉
     */
    COMPLAIN_REPORT(3, "投诉举报");

    /**
     * 类型
     */
    private Integer type;
    /**
     * 描述
     */
    private String description;

    FeedbackTypeEnum(Integer type, String description) {
        this.type = type;
        this.description = description;
    }
}
