package com.bxm.localnews.thirdparty.constant;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;

/**
 * @author zhaoyadong 2019/6/6 15:55
 * @desc
 */
public enum WxMaTemplateEnum {

    /**
     * 帖子被点赞
     */
    BELONG_POST_LIKE(PushMessageEnum.BELONG_POST_LIKE.getType(), "jcE7n9MVHK3J7YE3cSCSJhsRpeQ2iDrfTuZsmoWzLzE"),

    /**
     * 帖子被评论
     */
    BELONG_POST_REPLY(PushMessageEnum.BELONG_POST_REPLY.getType(), "mq0zc40I4Fjsl5CxLmp9mtwODnMKnGaLZqrKztOLPYo"),

    /**
     * 评论被点赞
     */
    NEWS_LIKE(PushMessageEnum.NEWS_LIKE.getType(), "7mo8yCbU3AXOTjZ6hteER8WA0QApe0lH1_f9IGczidU"),

    /**
     * 评论被点赞
     */
    POST_LIKE(PushMessageEnum.POST_LIKE.getType(), "7mo8yCbU3AXOTjZ6hteER8WA0QApe0lH1_f9IGczidU"),

    /**
     * 评论被回复
     */
    NEWS_REPLY(PushMessageEnum.NEWS_REPLY.getType(), "mq0zc40I4Fjsl5CxLmp9mrjmGIIVfLFsZE9sOq7A0Zk"),

    /**
     * 评论被回复
     */
    POST_REPLY(PushMessageEnum.POST_REPLY.getType(), "mq0zc40I4Fjsl5CxLmp9mrjmGIIVfLFsZE9sOq7A0Zk"),

    /**
     * 转发被阅读
     */
    FORWARDING(PushMessageEnum.FORWARDING.getType(), "dvPzQp-qJJj1phjaDM-pXxqwmZ_ZqbdNCZL568BKbsM"),

    /**
     * 邀请用户成功
     */
    INVITE(PushMessageEnum.INVITE.getType(), "FUnvEDhjGyBRiQMv8YZTJo0aEa8oGL3mDwIT_BvxwIg"),;


    private int type;

    private String templateId;

    WxMaTemplateEnum(int type, String templateId) {
        this.type = type;
        this.templateId = templateId;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public static WxMaTemplateEnum getTemplateEnumByType(int type) {
        for (WxMaTemplateEnum templateEnum : WxMaTemplateEnum.values()) {
            if (type == templateEnum.getType()) {
                return templateEnum;
            }
        }

        return null;
    }

}
