package com.bxm.localnews.thirdparty.enums;

import lombok.Getter;

/**
 * @author Administrator
 * @date 2020/10/23 10:38
 **/
@Getter
public enum FollowActEnum {
    /**
     *  "后续动作选项，0-无" +
     *  "1-打开商品" +
     *  "2-跳转链接" +
     *  "3-跳转联盟官方活动" +
     *  "4-跳转搜索" +
     *  "5-跳转千猪肯德基点餐" +
     *  "6-跳转到第三方广告" +
     *  "7-跳转我的收益"
     * */
    DEFAULT(0,"无"),
    OPEN_GOODS(1,"打开商品"),
    JUMP_URL(2,"跳转链接"),
    JUMP_ZONE_ACTIVE(3,"跳转联盟官方活动"),
    JUMP_SOURCE(4,"跳转搜索"),
    JUMP_KFC(5,"跳转千猪肯德基点餐"),
    JUMP_THIRDPARTY_AD(6,"跳转到第三方广告"),
    JUMP_MINE_INCOME(7,"跳转我的收益"),
    JUMP_ZERO_BUY(8,"跳转0元购"),
    JUMP_RED_FLOWER(9,"跳转红花夺宝"),
    JUMP_GOODS_ACTIVE(10,"跳转商品活动"),
    JUMP_HALF_OFF_GOODS(11,"五折商品"),
    WEEK_HOT_POST_RANK(12,"一周热门榜"),
    ;

    private Integer type;

    private String desc;

    FollowActEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
