package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;

public interface PopService {

    /**
     * 用途：根据用户获得弹窗（按优先级）
     * 场景：用户在打开app时会得到一个弹窗，弹窗由优先级配置
     *
     * @param homeWindowParam
     * @return
     */
    HomeWindowDTO getHomeWindow(HomeWindowParam homeWindowParam);

    /**
     * 添加隐私弹窗缓存
     *
     * @param userId 用户id
     */
    void addPrivacyPopCache(Long userId);
}
