package com.bxm.localnews.thirdparty.service;

import java.math.BigDecimal;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.newidea.component.vo.Message;

public interface PushMessageService {

    /**
     * 微信推送
     *
     * @param cash
     * @param userId
     */
    void pushMessage(BigDecimal cash, Long userId);

    /**
     * 推送对应类型的模板消息(备注：当前推送模板基于万事通小程序推送消息)
     *
     * @param message 消息体
     * @param appId   默认是万事通小程序的appId
     */
    void pushTemplateMessage(PushMessage message, String appId);

    /**
     * 微信公众号模板消息推送
     *
     * @param wechatMpPushMessage 消息体
     * @return 推送结果
     */
    Message pushOfficialAccountMsg(WechatMpPushMessage wechatMpPushMessage);
}
