package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "操作用户积分")
public class OperateUserPointDTO extends PointStoreBaseDTO {

    @ApiModelProperty("订单号")
    private String appOrderNum;

    protected OperateUserPointDTO() {
        super("ok", "");
    }

    protected OperateUserPointDTO(String appOrderNum) {
        super("ok", "");
        this.appOrderNum = appOrderNum;
    }

    protected OperateUserPointDTO(String status, String errorMessage) {
        super(status, errorMessage);
    }

    protected OperateUserPointDTO(String status, String errorMessage, String appOrderNum) {
        super(status, errorMessage);
        this.appOrderNum = appOrderNum;
    }

    public static OperateUserPointDTO success(String appOrderNum) {
        return new OperateUserPointDTO(appOrderNum);
    }

    public static OperateUserPointDTO fail(String message) {
        return new OperateUserPointDTO("fail", message);
    }

    public String getAppOrderNum() {
        return appOrderNum;
    }

    public void setAppOrderNum(String appOrderNum) {
        this.appOrderNum = appOrderNum;
    }
}
