package com.bxm.localnews.thirdparty.param;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.UserInfoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("首页弹窗传参实体")
public class AdvertisementParam extends BasicParam {

    @ApiModelProperty("广告类型" +
            "1:首页弹窗广告 2:日常任务广告 7:开屏广告 3：轮播广告 " +
            "4：个人中心轮播广告 8:首页配置广告 9:签到页面轮播广告 10:消息中心轮播广告 11:社区首页文字广告,12:IOS红包墙广告位," +
            "13:小程序首页,14:小程序悬浮广告,15:小程序首页弹窗广告,16:发布成功底部广告位,17:便民中心广告位,18:帖子分享页悬浮广告," +
            "19:新闻分享页悬浮广告,20:帖子分享页banner广告,21:新闻分享页banner广告,22:发布成功悬浮广告,23:新闻内容详情广告位," +
            "24:帖子内容详情广告位   25：vip页面球区 26：vip页面banner  27:vip页面特惠广告  28：特惠商家列表页面banner 29:已开卡权益页面-最近" +
            "特权  30:已开卡权益页面-热门特权   31:已开卡权益页面-影音娱乐  32：已开卡权益页面-美食餐饮 33：已开卡权益页面-返利商场 34" +
            "：已开卡权益页面-大牌返利   35：已开卡权益页面-超时购物  36：已开卡权益页面-旅游出行  37：已开卡权益页面-读书学习  38：已开卡权益页面" +
            "-生活服务  39：已开卡权益页面-车主福利  40：已开卡权益页面-医护健康  41：已开卡权益页面-免费专区  42：活动模板banner   43:vip资源位广告")
    private Byte type;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty(value = "请求SSP的 app 信息")
    private AppParam app;

    @ApiModelProperty(value = "请求SSP的 device 信息")
    private DeviceParam device;

    @Deprecated
    @ApiModelProperty("广告位id，多个用,分割")
    private String ids;

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private UserInfoDTO userInfo;

    @ApiModelProperty(value = "业务id （栏目id、商家分类id）同一个广告位在不同的分类下展示不同的广告时需要传递", required = false)
    private Long positionBizId;

    /**
     * 获取当前请求用户信息
     *
     * @return 当前用户完整信息，如果用户不存在，则可能为空
     */
    public UserInfoDTO loadCacheUserInfo() {
        if (null == userInfo && null != userId) {
            userInfo = new UserInfoDTO();
        }
        return userInfo;
    }
}
