package com.bxm.localnews.thirdparty.param;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.GeoReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.ScreenReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("请求SSP的 device 信")
public class DeviceParam {

    /**
     * 是
     * 设备的ip
     */
    @ApiModelProperty("是 设备的ip")
    private String ip;

    /**
     * 是
     * user agent
     */
    @ApiModelProperty(value = "是 user agent", required = true)
    private String ua;

    /**
     * 是
     * 设备型号
     */
    @ApiModelProperty(value = "是 设备型号", required = true)
    private String model;

    /**
     * 是
     * ⽣生产⼚厂商，例例如:"Samsung"
     */
    @ApiModelProperty(value = "是 ⽣生产⼚厂商，例例如:Samsun", required = true)
    private String make;

    /**
     * 是
     * ⼿手机品牌
     */
    @ApiModelProperty(value = "是 ⼿手机品牌", required = true)
    private String brand;

    /**
     * 是
     * 链接类型，空串串表示未知，wifi, 2g, 3g, 4g,5h， ethernet,cell_unknown
     */
    @JSONField(name = "connection_type")
    @ApiModelProperty(value = "是 链接类型，空串串表示未知，wifi, 2g, 3g, 4g,5h， ethernet,cell_unknown", required = true)
    private String connectionType;

    /**
     * 是
     * 设备⽅方向，1:纵向，2:横向
     */
    @ApiModelProperty(value = "是 设备⽅方向，1:纵向，2:横向", required = true)
    private Integer orientation;

    /**
     * 否
     * 运营商，0:移动，1:电信，3:联通，4:unknown
     */
    @ApiModelProperty("否 运营商，0:移动，1:电信，3:联通，4:unknown")
    private Integer carrier;

    /**
     * 否
     * MAC地址
     */
    @ApiModelProperty("否 MAC地址")
    private String mac;

    /**
     * 否
     * md5加密的MAC地址
     */
    @JSONField(name = "mac_md5")
    @ApiModelProperty("否 md5加密的MAC地址")
    private String macMd5;

    /**
     * 否
     * IMEI码
     */
    @ApiModelProperty("否 IMEI码")
    private String imei;

    /**
     * 否
     * md5加密的IMEI码
     */
    @JSONField(name = "imei_md5")
    @ApiModelProperty("否 md5加密的IMEI码")
    private String imeiMd5;

    /**
     * 否
     * imsi码
     */
    @ApiModelProperty("否 imsi码")
    private String imsi;

    /**
     * 否
     * Android ID
     */
    @JSONField(name = "android_id")
    @ApiModelProperty("否 Android ID")
    private String androidId;

    /**
     * 否
     * md5加密的Android ID
     */
    @JSONField(name = "android_id_md5")
    @ApiModelProperty("否 md5加密的Android ID")
    private String androidIdMd5;

    /**
     * 否
     * Android AD ID
     */
    @JSONField(name = "android_adid")
    @ApiModelProperty("否 Android AD ID")
    private String androidAdid;

    /**
     * 否
     * ios系统的idfa
     */
    @ApiModelProperty("否 ios系统的idfa")
    private String idfa;

    /**
     * 否
     * md5加密的ios系统的idfa
     */
    @JSONField(name = "idfa_md5")
    @ApiModelProperty("否 md5加密的ios系统的idfa")
    private String idfaMd5;


    /**
     * 是
     * 操作系统类型, "ios", "android", "wp"(windows phone)
     */
    @ApiModelProperty(value = "是 操作系统类型, ios android wp(windows phone)", required = true)
    private String os;

    /**
     * 是
     * 操作系统版本
     */
    @JSONField(name = "os_version")
    @ApiModelProperty(value = "是 操作系统版本", required = true)
    private String osVersion;


}
