/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.thirdparty.constant.GlobalFlagEnum;
import com.bxm.localnews.thirdparty.constant.ToolsSensitiveFlagEnum;
import com.bxm.localnews.thirdparty.constant.ToolsStatusEnum;
import com.bxm.localnews.thirdparty.domain.ToolsMapper;
import com.bxm.localnews.thirdparty.dto.ToolsDTO;
import com.bxm.localnews.thirdparty.service.ToolsService;
import com.bxm.localnews.thirdparty.vo.Tools;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToolsServiceImpl
implements ToolsService {
    private static final List<String> replaceList = Lists.newArrayList((Object[])new String[]{"{uid}"});
    private static final int AREA_CODE_LENGTH = 12;
    private ToolsMapper toolsMapper;
    private RedisHashMapAdapter redisHashMapAdapter;
    private AppVersionSupplyService appVersionSupplyService;
    private LocationFacadeService locationFacadeService;

    @Autowired
    public ToolsServiceImpl(ToolsMapper toolsMapper, RedisHashMapAdapter redisHashMapAdapter, AppVersionSupplyService appVersionSupplyService, LocationFacadeService locationFacadeService) {
        this.toolsMapper = toolsMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.appVersionSupplyService = appVersionSupplyService;
        this.locationFacadeService = locationFacadeService;
    }

    @Override
    public List<ToolsDTO> getToolsByAreaCode(String areaCode, Long userId, Integer isLogin, BasicParam basicParam, Byte locationType) {
        Boolean isPublishState = this.appVersionSupplyService.getPublishState(basicParam);
        List<ToolsDTO> toolsDTOS = this.getToolDTOsByToolsList(areaCode, isPublishState, locationType);
        ArrayList list = Lists.newArrayList();
        if (isLogin == 1) {
            list.add(userId.toString());
        } else {
            list.add("");
        }
        toolsDTOS.forEach(t -> {
            for (int i = 0; i < replaceList.size(); ++i) {
                String str = replaceList.get(i);
                if (!t.getUrl().contains(replaceList.get(i))) continue;
                t.setUrl(t.getUrl().replace(str, (CharSequence)list.get(i)));
            }
        });
        return toolsDTOS;
    }

    private List<Tools> getAllTools(String areaCode) {
        TypeReference<List<Tools>> typeReference = new TypeReference<List<Tools>>(){};
        List toolsList = (List)this.redisHashMapAdapter.get(this.getToolsListKey(), areaCode, (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)toolsList)) {
            String fullAreaCode = this.complteAreaCode(areaCode);
            toolsList = this.toolsMapper.getAllToolsByStatusAndAreaCode(ToolsStatusEnum.ENABLE.getStatus(), fullAreaCode, GlobalFlagEnum.IS_GLOBAL.getState());
            if (CollectionUtils.isNotEmpty((Collection)toolsList)) {
                this.redisHashMapAdapter.put(this.getToolsListKey(), areaCode, (Object)toolsList);
            }
        }
        return toolsList;
    }

    private KeyGenerator getToolsListKey() {
        return RedisConfig.THIRDPARTY_AREACODE_TOOLS.copy().appendKey((Object)"list");
    }

    private ToolsDTO getToolsDTOByTools(Tools tools) {
        ToolsDTO toolsDTO = new ToolsDTO();
        BeanUtils.copyProperties((Object)tools, (Object)toolsDTO);
        return toolsDTO;
    }

    private List<ToolsDTO> getToolDTOsByToolsList(String areaCode, Boolean isPublishState, Byte locationType) {
        List<Object> toolsList = this.getAllTools(areaCode);
        if (locationType != null && locationType == 1) {
            toolsList = toolsList.stream().filter(tools -> tools.getHomeFlag() != null && tools.getHomeFlag() == 1).collect(Collectors.toList());
            toolsList = this.getTop5ForList(toolsList);
        } else {
            toolsList = toolsList.stream().filter(tools -> tools.getHomeFlag() == null || tools.getHomeFlag() == 0).collect(Collectors.toList());
        }
        List<ToolsDTO> toolsDTOS = toolsList.stream().filter(tools -> isPublishState == false || !ToolsSensitiveFlagEnum.IS_SENSITIVE.getState().equals(tools.getSensitiveFlag())).map(this::getToolsDTOByTools).collect(Collectors.toList());
        return toolsDTOS;
    }

    private List<Tools> getTop5ForList(List<Tools> toolsList) {
        if (toolsList.size() > 5) {
            ArrayList tools = Lists.newArrayList();
            for (int i = 0; i < 5; ++i) {
                tools.add(toolsList.get(i));
            }
            return tools;
        }
        return toolsList;
    }

    private String complteAreaCode(String areaCode) {
        LocationDTO locationDTO;
        String fullCode = areaCode;
        if (StringUtils.isNotBlank((CharSequence)fullCode) && 12 != fullCode.length() && null == (locationDTO = this.locationFacadeService.getLocationByCode(fullCode = areaCode + "000000"))) {
            fullCode = areaCode.substring(0, 4) + "00000000";
        }
        return fullCode;
    }
}

