package com.bxm.localnews.thirdparty.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "thirdparty.config.wechat.applet")
public class WechatProperties {

    /**
     * 微信-小程序标识
     */
    private String appId;

    /**
     * 小程序的 app secret
     */
    private String secret;

    private String pushPage;

    private String templateId;

    /**
     * 下载地址
     */
    private String downloadUrl;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    /**
     * @return the pushPage
     */
    public String getPushPage() {
        return pushPage;
    }

    /**
     * @param pushPage the pushPage to set
     */
    public void setPushPage(String pushPage) {
        this.pushPage = pushPage;
    }

    /**
     * @return the templateId
     */
    public String getTemplateId() {
        return templateId;
    }

    /**
     * @param templateId the templateId to set
     */
    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}
