package com.bxm.localnews.thirdparty.config;

import com.bxm.newidea.component.redis.RedisStringAdapter;

import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2018/10/17 14:22
 * @desc
 */
@Component
public class WxMpConfig {

    private final static Logger logger = LoggerFactory.getLogger(WxMpConfig.class);

    private WechatAccountConfig wechatAccountConfig;

    @Autowired
    public WxMpConfig(WechatAccountConfig wechatAccountConfig) {
        this.wechatAccountConfig = wechatAccountConfig;
    }

    @Bean
    public WxMpService wxMpService(RedisStringAdapter redisStringAdapter) {
        //创建WxMpService实例并设置appid和sectret
        WxMpService wxMpService = new WxMpServiceImpl();
        //这里的设置方式是跟着这个sdk的文档写的
        wxMpService.setWxMpConfigStorage(wxConfigProvider(redisStringAdapter));
        return wxMpService;
    }

    @Bean
    public WxMpConfigStorage wxConfigProvider(RedisStringAdapter redisStringAdapter) {
        WxMpInMemoryConfigStorage wxConfigProvider = new WxMpInRedisConfigStorage(redisStringAdapter);
        wxConfigProvider.setAppId(wechatAccountConfig.getAppId());
        wxConfigProvider.setSecret(wechatAccountConfig.getAppSecret());
        return wxConfigProvider;
    }

    @Bean
    public WxMpService h5WxMpService(RedisStringAdapter redisStringAdapter) {
        //创建WxMpService实例并设置appid和sectret
        WxMpService wxMpService = new WxMpServiceImpl();
        //这里的设置方式是跟着这个sdk的文档写的
        wxMpService.setWxMpConfigStorage(h5WxConfigProvider(redisStringAdapter));
        return wxMpService;
    }

    @Bean
    public WxMpConfigStorage h5WxConfigProvider(RedisStringAdapter redisStringAdapter) {
        WxMpInMemoryConfigStorage wxConfigProvider = new WxMpInRedisConfigStorage(redisStringAdapter);
        wxConfigProvider.setAppId(wechatAccountConfig.getH5AppId());
        wxConfigProvider.setSecret(wechatAccountConfig.getH5AppSecret());
        return wxConfigProvider;
    }
}
