package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.vo.Banner;

import java.util.List;
import java.util.Map;

/**
 * 广告位
 * Created by Administrator on 2018/2/7 0007.
 */
public interface BannerService {

    /**
     * banner列表
     * @param bannerType 类型
     * @return 对应类型的banner列表
     */
    List<Banner> queryBannerList(Byte bannerType);

    /**
     * banner列表
     * @param searchMap 搜索条件
     * @param current 页码
     * @param pageSize 长度
     * @return 对应搜索条件的banner列表
     */
    List<Banner> listBanner(Map<String, Object> searchMap, int current, int pageSize);

    /**
     * 添加banner
     * @param Banner
     * @param functionId
     * @return
     */
    Json insertSelective(Banner Banner, Integer functionId);

    /**
     * 更新banner
     * @param Banner
     * @param functionId
     * @return
     */
    Json updateBySelective(Banner Banner, Integer functionId);

    /**
     * 更新banner状态
     * @param bannerId
     * @param state 状态
     * @return
     */
    Json changeState(Long bannerId, String state);

    /**
     * banner
     * @param id
     * @return
     */
    Banner getBanner(Integer id);

    /**
     * 批量更新banner状态
     * @param ids
     * @param status
     * @return
     */
    int updateBannerStatusByIds(Long[] ids, Byte status);

}
