package com.bxm.localnews.thirdparty.service;

import java.util.List;

import com.bxm.localnews.thirdparty.dto.WeatherDTO;
import com.bxm.localnews.thirdparty.dto.WeatherExtendDTO;

/**
 * @author zhaoyadong 2018/10/18 13:53
 * @desc
 */
public interface WeatherService {

    /**
     * 根据地区编码获取天气信息
     *
     * @param adcode
     * @return
     */
    WeatherDTO getWeatherByAdcode(String adcode);

    /**
     * 根据地区编码获取天气信息（首页）
     *
     * @param adcode
     * @return
     */
    WeatherDTO getHomeWeatherByAdcode(String adcode);

    /**
     * 获取未来7天的天气预报
     *
     * @param adcode
     * @return
     */
    List<WeatherExtendDTO> getFutureWeather(String adcode);
}
