package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;

public interface WechatService {

    /**
     * 根据code 获取用户的 openid session_key
     *
     * @param wechatDto
     * @return com.bxm.localnews.thirdparty.dto.WxUserInfo
     * @throws
     */
    WxUserInfo getWechatInfo(WechatDto wechatDto);

    /**
     * 获取微信小程序分享二维码地址
     *
     * @param wechatDto
     * @return java.lang.String
     * @throws
     */
    String getWechatQRCode(WechatDto wechatDto);

    /**
     * 解密数据，创建账号
     *
     * @param encryptedData
     * @param sessionKey
     * @param iv
     * @param inviteUserId
     * @param ip
     * @param platform
     * @param area
     * @return java.lang.String
     */
    String createUser(String encryptedData, String sessionKey, String iv,
                      Long inviteUserId, String ip, String platform, String area);

    /**
     * 设置用户formId
     *
     * @param userId
     * @param formId
     * @return
     */
    Boolean setUserFormId(Long userId, String formId);

    /**
     * 获取微信token
     *
     * @return
     */
    String getWeChatToken();

    /**
     * 清空微信token
     */
    void emptyWeChatToken();
}
